# 帳票設計書 36-next info診断レポート

## 概要

本ドキュメントは、`next info` コマンドで出力されるシステム情報レポートの設計仕様を定義する。

### 本帳票の処理概要

本帳票は、`next info` コマンドを実行した際に、Next.jsアプリケーションの実行環境に関する診断情報をコンソールに出力するものである。OS情報、バイナリバージョン、パッケージバージョン、Next.js設定等を含む。

**業務上の目的・背景**：Next.jsの問題報告（Issue）やデバッグにおいて、実行環境の情報を迅速に収集・共有するために使用される。特にGitHub Issueへの情報添付を念頭に設計されており、ユーザーがコマンド一つで環境情報を収集できることを目的とする。

**帳票の利用シーン**：(1) GitHub Issueへの環境情報添付、(2) サポート問い合わせ時の環境情報提供、(3) Next.jsバージョンの陳腐化チェック、(4) `--verbose`オプションによるnext-swcの詳細診断。

**主要な出力内容**：
1. OS情報（プラットフォーム、アーキテクチャ、バージョン、メモリ、CPUコア数）
2. バイナリバージョン（Node.js、npm、Yarn、pnpm）
3. パッケージバージョン（next、eslint-config-next、react、react-dom、typescript）
4. Next.js設定（output設定）
5. バージョン陳腐化警告（最新版との比較）

**帳票の出力タイミング**：`next info` コマンド実行時。

**帳票の利用者**：開発者、テクニカルサポート担当者、OSS貢献者。

## 帳票種別

コンソール出力（標準出力への診断情報テキスト表示）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next info` | コマンド実行 |
| N/A | CLIコマンド（詳細） | `next info --verbose` | コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（コンソール出力） |
| 用紙サイズ | N/A（コンソール出力） |
| 向き | N/A |
| ファイル名 | N/A（ファイル出力なし、標準出力のみ） |
| 出力方法 | console.log経由の標準出力 |
| 文字コード | UTF-8 |

### PDF固有設定

N/A

### Excel固有設定

N/A

## 帳票レイアウト

### レイアウト概要

セクション分けされたテキスト形式で環境情報を表示する。

```
Operating System:
  Platform: darwin
  Arch: arm64
  Version: Darwin Kernel Version 23.6.0
  Available memory (MB): 16384
  Available CPU cores: 10
Binaries:
  Node: 20.11.0
  npm: 10.2.4
  Yarn: 1.22.19
  pnpm: 8.15.1
Relevant Packages:
  next: 15.0.0 // Latest available version is 15.0.1
  eslint-config-next: 15.0.0
  react: 19.0.0
  react-dom: 19.0.0
  typescript: 5.3.3
Next.js Config:
  output: N/A
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Operating System | OS情報セクション | os モジュール | セクションヘッダー |
| 2 | Binaries | バイナリバージョンセクション | process / childProcess | セクションヘッダー |
| 3 | Relevant Packages | パッケージバージョンセクション | require() | セクションヘッダー |
| 4 | Next.js Config | 設定情報セクション | loadConfig | セクションヘッダー |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Platform | OSプラットフォーム | os.platform() | 文字列 | 可変 |
| 2 | Arch | CPUアーキテクチャ | os.arch() | 文字列 | 可変 |
| 3 | Version | OSバージョン | os.version() | 文字列 | 可変 |
| 4 | Available memory (MB) | 利用可能メモリ（MB） | Math.ceil(os.totalmem()/1024/1024) | 整数 | 可変 |
| 5 | Available CPU cores | CPUコア数 | os.cpus().length | 整数またはN/A | 可変 |
| 6 | Node | Node.jsバージョン | process.versions.node | 文字列 | 可変 |
| 7 | npm | npmバージョン | getBinaryVersion('npm') | 文字列またはN/A | 可変 |
| 8 | Yarn | Yarnバージョン | getBinaryVersion('yarn') | 文字列またはN/A | 可変 |
| 9 | pnpm | pnpmバージョン | getBinaryVersion('pnpm') | 文字列またはN/A | 可変 |
| 10 | next | Next.jsバージョン + 陳腐化情報 | getPackageVersion('next') | バージョン + 陳腐化メッセージ | 可変 |
| 11 | eslint-config-next | ESLint設定バージョン | getPackageVersion | 文字列またはN/A | 可変 |
| 12 | react | Reactバージョン | getPackageVersion | 文字列またはN/A | 可変 |
| 13 | react-dom | React DOMバージョン | getPackageVersion | 文字列またはN/A | 可変 |
| 14 | typescript | TypeScriptバージョン | getPackageVersion | 文字列またはN/A | 可変 |
| 15 | output | Next.js出力モード | config.output | 文字列またはN/A | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 陳腐化警告 | バージョンが古い場合の更新推奨メッセージ | versionInfo.staleness | 黄色警告テキスト |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 通常モード | `next info` で基本情報を出力 | Yes |
| 詳細モード | `next info --verbose` で追加診断情報を出力 | No |
| NEXT_RSPACKフラグ | 設定時にnext-rspackバージョンも表示 | No |

### ソート順

N/A（固定レイアウト）

### 改ページ条件

N/A

## データベース参照仕様

N/A

### 参照テーブル一覧

N/A

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| メモリ（MB） | Math.ceil(os.totalmem() / 1024 / 1024) | 切り上げ | バイトからMBに変換 |
| バージョン陳腐化 | parseVersionInfo({installed, latest, canary}) → getStaleness() | N/A | npmレジストリからlatest/canaryタグを取得して比較 |
| バイナリバージョン | childProcess.execFileSync(binary, ['--version']) | N/A | 失敗時はN/Aを返す |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[next info 実行] --> B{--verbose?}
    B -->|No| C[printInfo 呼び出し]
    B -->|Yes| D[printVerboseInfo 呼び出し]
    C --> E[getPackageVersion でバージョン取得]
    E --> F[getNextConfig で設定取得]
    F --> G[npmレジストリからdist-tags取得]
    G --> H[parseVersionInfo でバージョン比較]
    H --> I[コンソール出力]
    I --> J{陳腐化あり?}
    J -->|Yes| K[更新推奨警告表示]
    J -->|No| L[終了]
    K --> L
    D --> M[各診断タスク実行]
    M --> N[Host system / Next.js installation / Node.js diagnostic / next-swc / shared deps]
    N --> O[診断レポート出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| dist-tags取得失敗 | npmレジストリへのfetchが失敗 | `warn - Failed to fetch latest canary version. (Reason: ...)` | ネットワーク接続確認。インストール済みバージョンのみ表示 |
| バイナリ不在 | npm/yarn/pnmバイナリが見つからない | N/A表示 | 該当パッケージマネージャの未インストールとして扱う |
| パッケージ不在 | requireでパッケージが見つからない | N/A表示 | 該当パッケージの未インストールとして扱う |
| 診断タスク失敗（verbose） | 各診断スクリプトが例外をスロー | `Unexpected failure while running diagnostics: {message}` | 個別タスクの失敗として記録、他のタスクは継続 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 固定項目数（約15項目） |
| 目標出力時間 | 数秒（npmレジストリへのfetch含む） |
| 同時出力数上限 | 1（CLIコマンド単発実行） |

## セキュリティ考慮事項

OS情報、Node.jsバージョン、パッケージバージョンなどの環境情報を出力する。`--verbose`モードではNode.js診断レポートからcwd、commandLine、host、cpus、networkInterfacesフィールドを削除してセキュリティに配慮している。出力をGitHub Issueに貼り付けることを想定しているため、機密情報が含まれないよう注意が必要。

## 備考

- `getPackageVersion`はrequireで`{package}/package.json`を読み込み、version属性を取得
- `getBinaryVersion`は`--version`フラグで各バイナリのバージョンを取得（execFileSync、失敗時はexecSync）
- `--verbose`モードではプラットフォーム別の診断スクリプトが実行される（win32/linux/darwin）
- `--verbose`モードではnext-swcのロード可否チェック、共有ライブラリ依存チェック（ldd/otool/dumpbin）が行われる
- `NEXT_RSPACK`環境変数が設定されている場合、next-rspackバージョンも表示される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

出力に使用されるデータ型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | next-info.ts | `packages/next/src/cli/next-info.ts` | NextInfoOptions型（行14-16）、TaskResult型（行18-24）、PlatformTaskScript型（行28-53） |

**読解のコツ**: 通常モード（printInfo）と詳細モード（printVerboseInfo）は完全に別の処理パス。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | next-info.ts | `packages/next/src/cli/next-info.ts` | nextInfo関数（行600-608）がメインエントリ |

**主要処理フロー**:
1. **行600-601**: `--verbose`フラグの判定
2. **行601-605**: フラグに応じてprintInfoまたはprintVerboseInfoを呼び出し

#### Step 3: 通常モード（printInfo）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | next-info.ts | `packages/next/src/cli/next-info.ts` | printInfo関数（行96-169） |

**主要処理フロー**:
- **行97-98**: パッケージバージョンと設定の取得
- **行104-133**: npmレジストリからdist-tagsを取得し、バージョン陳腐化をチェック
- **行135-162**: console.logで環境情報を出力
- **行164-168**: 陳腐化警告の表示

#### Step 4: 詳細モード（printVerboseInfo）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | next-info.ts | `packages/next/src/cli/next-info.ts` | printVerboseInfo関数（行254-593） |

**主要処理フロー**:
- **行270-531**: タスク定義配列（Host system / Next.js installation / Node.js diagnostic / next-swc / shared deps）
- **行540-577**: 各タスクを順次実行し結果を収集
- **行579-592**: 診断レポートの出力

### プログラム呼び出し階層図

```
next info (CLI)
    │
    └─ nextInfo() (行600)
           │
           ├─ printInfo() (通常モード)
           │      ├─ getPackageVersion() → パッケージバージョン取得
           │      ├─ getNextConfig() → Next.js設定取得
           │      ├─ fetch(registry + dist-tags) → 最新バージョン取得
           │      ├─ parseVersionInfo() → バージョン比較
           │      └─ console.log() → 環境情報出力
           │
           └─ printVerboseInfo() (詳細モード)
                  ├─ Host system → WSL/Docker/CI判定
                  ├─ Next.js installation → バージョン・設定情報
                  ├─ Node.js diagnostic → process.report
                  ├─ next-swc installation → loadBindings()確認
                  └─ next-swc shared deps → ldd/otool/dumpbin確認
```

### データフロー図

```
[入力]                          [処理]                              [出力]

os モジュール ─────────────────▶ printInfo()
process.versions ──────────────▶    ├─ OS情報収集
npm/yarn/pnpm binaries ───────▶     ├─ バイナリバージョン取得
node_modules/*/package.json ──▶     ├─ パッケージバージョン取得    ──▶ コンソール出力
npm registry ──────────────────▶    ├─ 最新バージョン取得            (stdout)
next.config.js ────────────────▶    └─ 設定情報取得
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| next-info.ts | `packages/next/src/cli/next-info.ts` | ソース | nextInfo, printInfo, printVerboseInfo関数の実装 |
| next.ts | `packages/next/src/bin/next.ts` | ソース | CLIエントリポイントからnextInfoの呼び出し |
| parse-version-info.ts | `packages/next/src/server/dev/parse-version-info.ts` | ソース | parseVersionInfo関数 |
| version-staleness.ts | `packages/next/src/next-devtools/shared/version-staleness.ts` | ソース | getStaleness関数 |
| get-registry.ts | `packages/next/src/lib/helpers/get-registry.ts` | ソース | npmレジストリURL取得 |
| config.ts | `packages/next/src/server/config.ts` | ソース | loadConfig関数 |
